﻿local Event = require 'utils.event'
local Token = require 'utils.global_token'

-- code for disable landfill technologie:
Event.add(defines.events.on_player_joined_game, function(event)
    local player = game.players[event.player_index]
        game.forces["player"].technologies["landfill"].enabled = false
end)

local entity_drop_amount = {
    ['small-biter'] = {low = 1, high = 20},
    ['small-spitter'] = {low = 1, high = 20},
    ['medium-biter'] = {low = 10, high = 30},
    ['medium-spitter'] = {low = 10, high = 30},
    ['big-biter'] = {low = 20, high = 40},
    ['big-spitter'] = {low = 20, high = 40},
    ['behemoth-biter'] = {low = 30, high = 50},
    ['behemoth-spitter'] = {low = 30, high = 50}
}

local loot_raffle = {"iron-ore", "copper-ore", "coal", "stone", "landfill", "uranium-ore", "crude-oil-barrel"}

local loot = {
    ['iron'] = {weight = 200, name = 'iron-ore'},
	['copper'] = {weight = 120, name = 'copper-ore'},
	['coal'] = {weight	= 150, name = 'coal'},
	['stone'] = {weight = 130, name = 'stone'},
	['landfill'] = {weight = 20, name = 'landfill'},
	['uranium'] = {weight = 10, name = 'uranium-ore'},
	['oil'] = {weight = 5, name = 'crude-oil-barrel'}
}

local function on_built_entity (event)
	if event.created_entity.name == "artillery-turret" or
		event.created_entity.name == "flamethrower-turret" or
		event.created_entity.name == "laser-turret" or
		event.created_entity.name == "gun-turret" or
		event.created_entity.name == "car" or
    event.created_entity.name == "artillery-wagon" or
		event.created_entity.name == "tank" then
			event.created_entity.die("enemy")
			game.print("Turrets, cars and Tanks are disabled!")
		end
	end

local function randomize ()
	local return_value = nil
	local total_weight = loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight + loot['landfill'].weight + loot['uranium'].weight + loot['oil'].weight
	local rand_value = math.random(0, total_weight)
	if rand_value <  loot['iron'].weight then
		return loot['iron'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight) then
		return loot['copper'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight) then
		return loot['coal'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight) then
		return loot['stone'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight + loot['landfill'].weight) then
		return loot['landfill'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight + loot['landfill'].weight + loot['uranium'].weight) then
		return loot['uranium'].name
	end
	return loot['oil'].name
end

local function on_entity_died(event)
	local entity = event.entity
	if not entity or not entity.valid then
		return
	end
	local name = entity.name
	local bounds = entity_drop_amount[name]
	if bounds then
		local c = math.random(bounds.low, bounds.high)
		if c > 0 then
			local dropped = randomize()
			game.surfaces[1].spill_item_stack(entity.position,{name = dropped, count = c},true)
		end
	end
end

Event.add(defines.events.on_built_entity, on_built_entity)
Event.add(defines.events.on_entity_died, on_entity_died)
